package MusicLandscape.util.matcher;

import MusicLandscape.entities.Track;
import MusicLandscape.util.MyStringMatcher;

/**
 * Encapsulates the concept of matching a track based on its title.
 * <p>
 * This class is used to test whether a given track's title starts with a certain string,
 * the starting string being the pattern of this matcher.
 * <p>
 * The pattern is a simple string. Null patterns are not accepted.
 *
 * @author Jonas Altrock (ew20b126@technikum-wien.at)
 * @version 1
 * @since ExerciseSheet05
 */
public class TitleMatcher extends MyStringMatcher<Track> {
    /**
     * Creates a Matcher object with a specified pattern.<br>
     *
     * @param pat the pattern of this matcher
     */
    public TitleMatcher(String pat) {
        super(pat);
    }

    /**
     * Matches an object against the pattern of this matcher.
     *
     * @param track the object to match
     * @return whether t matches the pattern of this matcher.
     */
    @Override
    public boolean matches(Track track) {
        return track.getTitle().matches("^" + pattern + ".*");
    }

    /**
     * the string representation is <kbd>title starts with (PATTERN)</kbd>
     *
     * @return a string representation of the object.
     */
    @Override
    public String toString() {
        return "title starts with (" + pattern + ")";
    }

    /**
     * We have to redeclare the pattern field because the TitleMatcherTest is brittle.<br>
     * Pattern to matcht the track's title against.
     */
    protected String pattern;

    /**
     * We have to redefine this method because the TitleMatcherTest is brittle.<br>
     * Sets the pattern of this matcher.
     * <p>
     * Null is not accepted.
     *
     * @param pat the pattern to set
     */
    @Override
    public void setPattern(String pat) {
        super.setPattern(pat);
        pattern = super.pattern;
    }
}
